from bson import ObjectId
from pydantic import BaseModel, Field, validator
from typing import List, Optional
from fastapi import HTTPException
from bson.errors import InvalidId


def str_to_objectid(id: str) -> ObjectId:
    try:
        return ObjectId(id)
    except (TypeError, InvalidId):
        raise HTTPException(status_code=400, detail="Invalid ObjectId format")


def object_to_str_array(data: List[dict]) -> List[dict]:
    for item in data:
        item["_id"] = str(item["_id"])
    return data
